using System;
using System.Collections.Generic;
using System.Text;
using System.Security.Cryptography;
using System.IO;

namespace SignedHash
{
   class Program
   {
      static void Main(string[] args)
      {
         string verifiableMessage = "To byy najlepsze czasy, to byy najgorsze czasy.";
         SHA1Managed sha = new SHA1Managed();
         byte[] hashValue =
           sha.ComputeHash(System.Text.ASCIIEncoding.ASCII.GetBytes(verifiableMessage));

         // teraz, skoro ju mamy skrt, stwrz sygnatur w oparciu o ten skrt
         // uyj ponownie klucza Joanny.
         StreamReader sr = File.OpenText(@"..\..\..\..\JanesPrivateKey.xml");
         string janesKey = sr.ReadToEnd();

         RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
         rsa.FromXmlString(janesKey);

         RSAPKCS1SignatureFormatter sigFormatter = new RSAPKCS1SignatureFormatter(rsa);
         sigFormatter.SetHashAlgorithm("SHA1");
         byte[] signedHash = sigFormatter.CreateSignature(hashValue);

         // zapisz podpisany skrt na dysk
         FileStream fs = new FileStream(@"..\..\..\..\SignedHash.dat", FileMode.Create);
         fs.Write(signedHash, 0, signedHash.Length);
         fs.Close();
      }
   }
}
